#include <iostream>
#include <string>
#include <queue>
#include <algorithm>

using namespace std;

struct Edge {
	int dest;
	int cap;
	int flow;
	int back;
};

int N;
vector<vector<Edge>> G;

void addEdge(int a, int b, int flow, int cap) {
	if(a == b) return;
	Edge e1{b, cap, flow, (int)G[b].size()};
	Edge e2{a, 0, -flow, (int)G[a].size()};
	G[a].push_back(e1);
	G[b].push_back(e2);
}

vector<vector<int>> L;
vector<int> K;

bool yes[4005];
bool visited[4005];

void dfs(int v) {
	if(visited[v]) return;
	visited[v] = true;
	if(v == 2 * N + 1) {
		yes[v] = true;
		return;
	}
	yes[v] = false;
	for(Edge e : G[v]) {
		if(e.flow == e.cap) continue;
		dfs(e.dest);
		if(yes[e.dest]) yes[v] = true;
	}
}

int main() {
	cin.sync_with_stdio(false);
	
	cin >> N;
	G.resize(2 * N + 2);
	L.resize(N);
	K.resize(N);
	
	for(int b = 0; b < N; ++b) {
		int cnt;
		cin >> cnt;
		L[b].resize(cnt);
		
		for(int i = 0; i < cnt; ++i) {
			cin >> L[b][i];
			--L[b][i];
		}
	}
	
	for(int b = 0; b < N; ++b) {
		cin >> K[b];
		--K[b];
	}
	
	for(int b = 0; b < N; ++b) {
		addEdge(2 * N, b, 1, 1);
	}
	for(int g = 0; g < N; ++g) {
		addEdge(N + g, 2 * N + 1, 1, 1);
	}
	
	for(int b = 0; b < N; ++b) {
		for(int g : L[b]) {
			addEdge(b, N + g, (int)(K[b] == g), 1);
		}
	}
	
	for(int b = 0; b < N; ++b) {
		for(Edge& e : G[2 * N]) {
			if(e.dest == b) --e.flow;
		}
		for(Edge& e : G[b]) {
			if(e.dest == N + K[b]) --e.flow;
		}
		for(Edge& e : G[N + K[b]]) {
			if(e.dest == 2 * N + 1) --e.flow;
		}
		
		fill(yes, yes + 4005, false);
		fill(visited, visited + 4005, false);
		dfs(2 * N);
		
		int cnt = 0;
		for(int g : L[b]) {
			if(yes[N + g]) ++cnt;
		}
		cout << cnt;
		for(int g : L[b]) {
			if(yes[N + g]) cout << ' ' << g + 1;
		}
		cout << "\n";
		
		for(Edge& e : G[2 * N]) {
			if(e.dest == b) ++e.flow;
		}
		for(Edge& e : G[b]) {
			if(e.dest == N + K[b]) ++e.flow;
		}
		for(Edge& e : G[N + K[b]]) {
			if(e.dest == 2 * N + 1) ++e.flow;
		}
	}
	
	return 0;
}
